/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.factories;

import com.badlogic.gdx.math.RandomXS128;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Random;
import technology.rocketjump.undermount.entities.factories.AccessoryColorFactory;
import technology.rocketjump.undermount.entities.factories.HairColorFactory;
import technology.rocketjump.undermount.entities.factories.HumanoidNameGenerator;
import technology.rocketjump.undermount.entities.factories.SkinColorFactory;
import technology.rocketjump.undermount.entities.model.physical.humanoid.Gender;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HumanoidEntityAttributes;

@Singleton
public class HumanoidEntityAttributesFactory {
    private final HairColorFactory hairColorFactory;
    private final SkinColorFactory skinColorFactory;
    private final AccessoryColorFactory accessoryColorFactory;
    private final HumanoidNameGenerator humanoidNameGenerator;
    private final Random random = new RandomXS128();

    @Inject
    public HumanoidEntityAttributesFactory(HairColorFactory hairColorFactory, SkinColorFactory skinColorFactory, AccessoryColorFactory accessoryColorFactory, HumanoidNameGenerator humanoidNameGenerator) {
        this.hairColorFactory = hairColorFactory;
        this.skinColorFactory = skinColorFactory;
        this.accessoryColorFactory = accessoryColorFactory;
        this.humanoidNameGenerator = humanoidNameGenerator;
    }

    public HumanoidEntityAttributes create() {
        HumanoidEntityAttributes attributes = new HumanoidEntityAttributes(this.random.nextLong(), this.hairColorFactory.randomHairColor(this.random), this.skinColorFactory.randomSkinColor(this.random), this.accessoryColorFactory.randomAccessoryColor(this.random));
        attributes.setName(this.humanoidNameGenerator.create(attributes.getSeed(), attributes.getGender()));
        if (this.random.nextFloat() <= this.chanceToHaveHair(attributes)) {
            attributes.setHasHair(true);
        } else {
            attributes.setHasHair(false);
        }
        return attributes;
    }

    private float chanceToHaveHair(HumanoidEntityAttributes attributes) {
        if (attributes.getGender().equals((Object)Gender.MALE)) {
            return 0.3f;
        }
        if (attributes.getGender().equals((Object)Gender.FEMALE)) {
            return 1.0f;
        }
        return 0.0f;
    }
}

